
$housingIconMap::icon[0] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/0_no_icon.png";
$housingIconMap::icon[1] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/1_house.png";
$housingIconMap::icon[2] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/2_bungalow.png";
$housingIconMap::icon[3] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/3_cottage.png";
$housingIconMap::icon[4] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/4_villa.png";
$housingIconMap::icon[5] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/5_mansion.png";
$housingIconMap::icon[6] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/6_estate.png";
$housingIconMap::icon[7] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/7_penthouse.png";
$housingIconMap::icon[8] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/8_apt_free.png";
$housingIconMap::icon[9] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/9_apt_dlx.png";
$housingIconMap::icon[10] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/10_burninglands.png";
$housingIconMap::icon[11] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/11_house_space.png";
$housingIconMap::icon[12] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/12_bungalow_space.png";
$housingIconMap::icon[13] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/13_cottage_space.png";
$housingIconMap::icon[14] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/14_villa_space.png";
$housingIconMap::icon[15] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/15_mansion_space.png";
$housingIconMap::icon[16] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/16_estate_space.png";
$housingIconMap::icon[17] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/17_land_space.png";
$housingIconMap::icon[18] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/18_apt_free.png";
$housingIconMap::icon[19] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/19_apt_dix.png";
$housingIconMap::icon[20] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/20_land_island.png";
$housingIconMap::icon[21] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/21_mountainview_land.png";
$housingIconMap::icon[22] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/22_burning_lands_home.png";
$housingIconMap::icon[23] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/23_echocanyon_landplots.png";
$housingIconMap::icon[24] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/24_echocanyon_outposts.png";
$housingIconMap::icon[25] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/25_sharktanks.png";
$housingIconMap::icon[26] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/26_estate_hub.png";
$housingIconMap::icon[27] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/27_suburbia.png";
$housingIconMap::icon[28] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/28_apt_free.png";
$housingIconMap::icon[29] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/29_apt_dlx.png";
$housingIconMap::icon[30] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/30_enchanted_landplots.png";
$housingIconMap::icon[31] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/31_house_forest.png";
$housingIconMap::icon[32] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/32_bungalow_forest.png";
$housingIconMap::icon[33] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/33_cottage_forest.png";
$housingIconMap::icon[34] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/34_villa_forest.png";
$housingIconMap::icon[35] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/35_mansion_forest.png";
$housingIconMap::icon[36] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/36_enchanted_estates.png";
$housingIconMap::icon[37] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/37_castle_forest.png";
$housingIconMap::icon[38] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/38_tower_forest.png";
$housingIconMap::icon[39] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/39_penthouse_deluxe.png";
$housingIconMap::icon[40] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/40_cabana.png";
$housingIconMap::icon[41] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/41_mansion_cake.png";
$housingIconMap::icon[42] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/42_house_cake.png";
$housingIconMap::icon[43] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/43_cottage_cake.png";
$housingIconMap::icon[44] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/44_bungalow_cake.png";
$housingIconMap::icon[45] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/45_estate_cake.png";
$housingIconMap::icon[46] = "onverse/data/live_assets/engine/ui/images/icons/directory/home_list/46_land_cake.png";

function GetHousingIcon(%iconID)
{
    if ($housingIconMap::icon[%iconID] $= "")
    {
        %iconID = 0;
    }
    return $housingIconMap::icon[%iconID];
}

new GuiControlProfile(GuiTestTextListProfile : GuiTextListProfile) {
   border = "1";
   borderColor = "255 255 255";
   fontSize = "20";
   textOffset = "0 0";
   fontColors[0] = "255 255 255";
   fontColors[1] = "255 255 255";
   fontColors[2] = "38 57 98";
};

new GuiControlProfile(GuiStretchButtonBarProfile : GuiDefaultProfile) {
   bitmap = "~/data/live_assets/engine/ui/images/border_button_bar";
};

exec("./homeList.gui");

function showHomeList(%username)
{
    if (%username $= "")
    {
        %username = $currentPlayerName;
    }
    if (!homeListGUI.isAwake())
    {
        homeListGUI.currentUsername = %username;
        Canvas.pushDialog(homeListGUI);
    }
    else
    {
        if (%username $= homeListGUI.currentUsername)
        {
            Canvas.popDialog(homeListGUI);
            return;
        }
        homeListGUI.currentUsername = %username;
        homeListGUI.refreshData();
    }
}

function homeListGUI::onWake(%this)
{
    %this.refreshData();
}

function homeListGUI::refreshData(%this)
{
    %this.currentRPC = new RPC_GetUserHousing() {
    };
    %this.currentRPC.username = %this.currentUsername;
    %this.currentRPC.fireRPC(MasterServerConnection);
    %this._(homeList).clear();
    %this._(homeList).dataSet = 0;
    
    if ($currentPlayerName $= %this.currentUsername)
    {
        homeListGUI._(window).setText("My Homes");
        homeListGUI._(rename).setVisible(1);
        homeListGUI._(makedefault).setVisible(1);
    }
    else
    {
        homeListGUI._(window).setText(%this.currentUsername @ "\'s Homes");
        homeListGUI._(rename).setVisible(0);
        homeListGUI._(makedefault).setVisible(0);
    }
}

function homeListGUI::addDataRow(%this, %rowdata)
{
    %id = %this._(homeList).dataSet;
    %iconID = getField(%rowdata, 3);
    %instance = getField(%rowdata, 5);
    %homeName = filterString(getField(%rowdata, 7), "*");
    if (%homeName $= "")
    {
        %homeName = getField(%rowdata, 6);
    }
    %bitmap = GetHousingIcon(%iconID);
    %this._(homeList).addRow(%id, %bitmap TAB %homeName TAB "\c2" @ %instance);
    %this._(homeList).dataSet[%this._(homeList).dataSet] = %rowdata;
    %this._(homeList).dataSet++;
    if (%this._(homeList).getSelectedId() == -1)
    {
        %this._(homeList).setSelectedRow(0);
    }
}

function homeListGUI::teleport(%this)
{
    %id = %this._(homeList).getSelectedId();
    %rowdata = %this._(homeList).dataSet[%id];
    if (%rowdata $= "")
    {
        error("No data to teleport to.");
        return;
    }

    resolveURL("onverse://location/" @ getField(%rowdata, 4) @ "/" @ getField(%rowdata, 5) @ "/" @ getField(%rowdata, 6));
}

function homeListGUI::showMap(%this)
{
    %id = %this._(homeList).getSelectedId();
    %rowdata = %this._(homeList).dataSet[%id];
    if (%rowdata $= "")
    {
        error("No data to show map of.");
        return;
    }

    if (DirectoryGUI.isAwake())
    {
        ShowDirectory();
    }
    resolveURL("onverse://location/" @ getField(%rowdata, 4) @ "/" @ getField(%rowdata, 5));
}

function homeListGUI::makedefault(%this)
{
    %id = %this._(homeList).getSelectedId();
    %rowdata = %this._(homeList).dataSet[%id];
    
    if (%rowdata $= "")
    {
        error("No data to make default.");
        return;
    }

    %rpcObject = new RPC_EditUserHouse() {
    };
    %rpcObject.makedefault(getField(%rowdata, 0));
    %rpcObject.fireRPC(MasterServerConnection);
    %this.refreshData();
}

function homeListGUI::rename(%this, %newName)
{
    %id = %this._(homeList).getSelectedId();
    %rowdata = %this._(homeList).dataSet[%id];
    if (%rowdata $= "")
    {
        error("No data to rename.");
        return;
    }
    if (%newName $= "")
    {
        %homeName = getField(%rowdata, 7);
        if (%homeName $= "")
        {
            %homeName = getField(%rowdata, 6);
        }
        MessageBoxEntryOk("New Name", "Enter a new name for this home:", %this @ ".rename", %homeName);
    }
    else
    {
        %rpcObject = new RPC_EditUserHouse() {
        };
        %rpcObject.rename(getField(%rowdata, 0), %newName);
        %rpcObject.fireRPC(MasterServerConnection);
        %this.refreshData();
    }
}

function onverseIconList::onRightMouseDown(%this, %unused, %y, %unused)
{
    %this.setSelectedRow(%y);
    homeListGUI.showContext();
}

function homeListGUI::showContext(%this)
{
    if (%this.currentUsername $= $currentPlayerName)
    {
        homesListContextMenu.showContextMenu("mine");
    }
    else
    {
        homesListContextMenu.showContextMenu("other");
    }
}

function homeListGUI::showHelpInfo(%this)
{
    showTutorialPopup("onverse/data/live_assets/text/tutorials/UI_tips/home_button/home_tips.txt");
}

function RPC_GetUserHousing::onReturnInvalidUsername(%this)
{
    error("RPC_GetUserHousing - onReturnInvalidUsername:" SPC %this.username);
    MessageBoxOK("Error", "Could not load home list for:" @ %this.username SPC "code:" @ %returnCode);
}

function RPC_GetUserHousing::onReturnDenied(%this)
{
    MessageBoxOK("Error", %this.username @ "\'s home list is private.");
}

function RPC_GetUserHousing::onReturnNoHouse(%this)
{
    if (%this.username $= $currentPlayerName)
    {
        showTutorialPopup("onverse/data/live_assets/text/tutorials/UI_tips/home_button/no_home.txt");
    }
    else
    {
        MessageBoxOK("No Homes", %this.username SPC "does not own any homes.");
    }
}

function RPC_GetUserHousing::onReturn(%this, %returnCode)
{
    if (homeListGUI.currentRPC == %this)
    {
        homeListGUI.currentRPC = "";
    }

    if (%returnCode < 0)
    {
        Canvas.popDialog(homeListGUI);
    }
}

function RPC_GetUserHousing::onHousingList(%this, %datastring)
{
    if (homeListGUI.currentRPC != %this)
    {
        return;
    }

    for (%i=0; %i < getRecordCount(%datastring); %i++)
    {
        homeListGUI.addDataRow(getRecord(%datastring, %i));
    }
}

function RPC_EditUserHouse::onReturnInvalidName(%this)
{
    error("RPC_GetUserHousing: Invalid home name.");
    MessageBoxOK("Error", "Invalid home name.");
}

function RPC_EditUserHouse::onReturnNameTooLong(%this)
{
    error("RPC_GetUserHousing: Name too long.");
    MessageBoxOK("Error", "Name is too long.");
}

new GuiContextMenu(homesListContextMenu) {
   Profile = "GuiMenuContextProfile";
   position = "0 0";
   Extent = "640 480";
};

function homesListContextMenu::Initialize(%this)
{
    if (!%this.initialized)
    {
        %menuId = 0;
        %itemId = 0;
        %this.addMenu("mine", %menuId++);
        %this.addMenuItem("mine", "Teleport", %itemId++, "homeListGUI.teleport();");
        %this.addMenuItem("mine", "Show on Map", %itemId++, "homeListGUI.showMap();");
        %this.addMenuItem("mine", "Rename", %itemId++, "homeListGUI.rename();");
        %this.addMenuItem("mine", "Make Default", %itemId++, "homeListGUI.makeDefault();");
        %itemId = 0;
        %this.addMenu("other", %menuId++);
        %this.addMenuItem("other", "Teleport", %itemId++, "homeListGUI.teleport();");
        %this.addMenuItem("other", "Show on Map", %itemId++, "homeListGUI.showMap();");
    }

    %this.initialized = 1;
}

function homesListContextMenu::showContextMenu(%this, %menu, %layer)
{
    %this.Initialize();
    Parent::showContextMenu(%this, %menu, %layer);
}
