
if (!isObject(CustomTemplateSet))
{
	new SimSet(CustomTemplateSet);
}

function clearCustomTemplates()
{
	%count = CustomTemplateSet.getCount();
	for (%i=0; %i<%count; %i++)
	{
		%obj = CustomTemplateSet.getObject(0);
		%obj.delete();
	}
}

function setupCustomGroups()
{
	// Define groups here. Check out names of lists in builder_templates.cs (i.e. tpl_* SimGroups)
	%groupAdd = new SimGroup() {
		displayName = "custom group shapes";

		new ScriptObject() {
			displayName = "king_frosty";
			func = "createTSStatic";
			class = "BuilderTemplate";
			shapeFile = "~/data/live_assets/shapes/dynamic/king_frosty.dts";
		};
	};
	tpl_scene_objects.add(%groupAdd); // Add to scene objects list
}

clearCustomTemplates();
setupCustomGroups();

function setupToolTargetBuilderGroup()
{
  %count = DataBlockGroup.getCount();
  for (%i=0; %i<%count; %i++)
  {
    %obj = DataBlockGroup.getObject(%i);
    if (%obj.className $= ToolTarget)
    {
      %so = new ScriptObject() {
        displayName = %obj.displayName $= "" ? %obj.getDataBlock() : %obj.displayName;
        func = "createInteractiveObject";
        class = "BuilderTemplate";
        datablock = %obj;
      };
      tpl_tool_targets.add(%so);
    }
  }
}

