//-----------------------------------------------------------------------------
// Torque Game Engine 
// Copyright (C) GarageGames.com, Inc.
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
// Mission Loading
// The server portion of the client/server mission loading process
//-----------------------------------------------------------------------------

//--------------------------------------------------------------------------
// Loading Phases:
// Phase 1: Transmit Datablocks
//          Transmit targets
// Phase 2: Transmit Ghost Objects
// Phase 3: Start Game
//
// The server invokes the client MissionStartPhase[1-3] function to request
// permission to start each phase.  When a client is ready for a phase,
// it responds with MissionStartPhase[1-3]Ack.

function GameConnection::loadMission(%this)
{
   // Send over the information that will display the server info
   // when we learn it got there, we'll send the data blocks
   %this.currentPhase = 0;
   if (%this.isAIControlled())
   {
      // Cut to the chase...
      %this.onClientEnterGame();
   }
   else
   {
      commandToClient(%this, 'BeginLocationDownload');
      echo("*** Sending mission load to client: " @ $Pref::Server::RootMission);
   }
}

function serverCmdLocationDownloadAck(%client)
{
   // Start with the CRC
   %client.setMissionCRC( $missionCRC );

   // Send over the datablocks...
   // OnDataBlocksDone will get called when have confirmation
   // that they've all been received.
   %client.transmitDataBlocks($missionSequence);
}

function GameConnection::onDataBlocksDone( %this, %missionSequence )
{
   // On to the next phase
   commandToClient(%this, 'LocationDownloadPhase2');
}

function serverCmdLocationDownloadPhase2Ack(%client, %seq)
{
   %client.currentPhase = 2;

   // Update mod paths, this needs to get there before the objects.
   %client.transmitPaths();

   // Start ghosting objects to the client
   %client.activateGhosting();

   // Setup inventory
   %client.updatePoints();
   echo("NOTE: Client inventory should be setup by now!");
}

function GameConnection::clientWantsGhostAlwaysRetry(%client)
{
   if($MissionRunning)
      %client.activateGhosting();
}


function GameConnection::onGhostAlwaysFailed(%client)
{

}

function GameConnection::onGhostAlwaysObjectsReceived(%client)
{
   // Ready for next phase.
   commandToClient(%client, 'LocationDownloadPhase3');
}

function serverCmdLocationDownloadPhase3Ack(%client)
{
   %client.currentPhase = 3;
   %client.setTurbo(0);
   %client.checkMaxRate();

   echo("Sending phase 4, builder=" @ $Server::Builder);
   commandToClient(%client, 'LocationDownloadPhase4', $Pref::Server::Builder, $Pref::Server::LocationId);
}

function serverCmdLocationDownloadPhase4Ack(%client, %poi)
{
   echo("phase 4 ack!!");
   // poi should be place we spawn at

   // Server is ready to drop into the game
   %client.startMission();
   %client.onClientEnterGame();
}
